/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class CreateWrenchingModifier
extends NoLevelsModifier {
    boolean enabled = ModList.get().isLoaded("create");
    Random rand = new Random();

    public InteractionResult beforeBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        if (this.enabled && !tool.isBroken() && context.m_43723_() != null) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            Block block = state.m_60734_();
            if (!(block instanceof IWrenchable)) {
                if (context.m_43723_().m_36341_() && AllTags.AllBlockTags.WRENCH_PICKUP.matches(state)) {
                    ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                    return this.onItemUseOnOther(world, pos, state, context);
                }
                return InteractionResult.PASS;
            }
            IWrenchable actor = (IWrenchable)block;
            ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
            if (context.m_43723_().m_36341_()) {
                return actor.onSneakWrenched(state, context);
            }
            return actor.onWrenched(state, context);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult onItemUseOnOther(Level world, BlockPos pos, BlockState state, UseOnContext context) {
        Player player = context.m_43723_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        state.m_60612_((ServerLevel)world, pos, ItemStack.f_41583_);
        world.m_46961_(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, (Vec3i)pos, 1.0f, this.rand.nextFloat() * 0.5f + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (context.getTarget() instanceof AbstractMinecart) {
            Player player = context.getPlayerAttacker();
            DamageSource source = player != null ? DamageSource.m_19344_((Player)player) : DamageSource.m_19370_((LivingEntity)context.getAttacker());
            context.getTarget().m_6469_(source, 100.0f);
        }
        return 0;
    }
}

